<?php
/*
Sample usage:
	$slugHome = $slugWP = 'myplugin';
	$admPageTitle = $this->t('My Settings');
	include 'hackadelic-StdAdmPageIntro.php';
*/
if ( !defined('ABSPATH') )
	exit('Sorry, you are not allowed to access this page directly.');
if ( !isset($this) || !is_a($this, HackadelicBase) )
	exit('Invalid operation context.');
if ( !isset($admPageTitle) )
	exit('Invalid operation context - $admPageTitle not set.');
if ( !isset($slugHome) )
	exit('Invalid operation context - $slugHome not set.');
if ( !isset($slugWP) )
	exit('Invalid operation context - $slugWP not set.');

$infomercials = array(
	array(
		'text' => 'Visit it',
		'url' => "http://hackadelic.com/solutions/wordpress/$slugHome",
		'icon' => "http://lh5.ggpht.com/_eYaV9fZ6qRg/SYj7lYcnwpI/AAAAAAAAAGU/VEJqpZPeMOc/s800/house.png" ),
	array(
		'text' => 'Comment it',
		'url' => "http://hackadelic.com/solutions/wordpress/$slugHome#comment",
		'icon' => "http://lh6.ggpht.com/_eYaV9fZ6qRg/SYj7etC7muI/AAAAAAAAAF0/K7EPBqbhKvc/s800/comment_edit.png" ),
	array(
		'text' => 'Rate it',
		'url' => "http://wordpress.org/extend/plugins/hackadelic-$slugWP/",
		'icon' => "http://lh4.ggpht.com/_eYaV9fZ6qRg/SYj7eq5ldaI/AAAAAAAAAFs/yeSKn1oBkfc/s800/award_star_gold_2.png" ),
	array(
		'text' => 'Support it',
		'url' => 'https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=1805414',
		'icon' => "http://lh4.ggpht.com/_eYaV9fZ6qRg/SYj7e6i0TAI/AAAAAAAAAGM/zDtI8EegmjE/s800/heart.png" ),
	array(
		'text' => 'Contact the author',
		'url' => 'http://hackadelic.com/contact',
		'icon' => "http://lh3.ggpht.com/_eYaV9fZ6qRg/SYj7erc84II/AAAAAAAAAF8/NiwCQIS83Xs/s800/email_edit.png" ),
	array(
		'hr' => true,
		'text' => 'Subscribe',
		'url' => 'http://hackadelic.com/feed',
		'icon' => "http://lh4.ggpht.com/_eYaV9fZ6qRg/SYj7e2bE8DI/AAAAAAAAAGE/FoHbGZM2j3A/s800/feed.png" ),
	array(
		'text' => 'Order a plugin',
		'url' => 'http://hackadelic.com/contact',
		'icon' => "http://lh5.ggpht.com/_eYaV9fZ6qRg/SYj7lcn3TFI/AAAAAAAAAGc/IIpGTWolB7k/s800/lightbulb.png" ),
);

?>
<style type="text/css">
	.wp-admin form, .wp-admin div.updated {
		margin-right: 180px
	}
	.wp-admin div.updated {
		margin-top: 1em;
		margin-bottom: 1em;
	}
	div.hackadelic-adminfobar {
		float: right;
		width: 150px;
		border-left: 1px solid #ccc;
		padding-left: 1em;
	}
	.hackadelic-adminfobar a {
		text-decoration: none
	}
	.hackadelic-adminfobar ul {
		list-style: inside;
		padding: 0;
	}
	.hackadelic-adminfobar li {
		margin: .75em 0 .75em 0;
	}
	.hackadelic-adminfobar hr {
		color: #ccc
	}
</style>
<div class="wrap">
<h2><?php echo $this->PLUGIN_TITLE, ' ', $admPageTitle ?></h2>

<div class="hackadelic-adminfobar">
<center>
<?php $this->e('You are using a') ?>
 <strong><?php $this->e('Hackadelic PlugIn') ?></strong>
</center>
<hr size="0" />
<ul>
<?php foreach ($infomercials as $each) : unset($hr) ; extract($each) ?>
	<?php if ($hr) : ?><hr size="0" /><?php endif ?>
	<li style="list-style-image:url(<?php echo $icon ?>)">
	<a href="<?php echo $url ?>" ><?php $this->e($text) ?></a>
	</li>
<?php endforeach ?>
</ul><?php /*
	<p><em><?php $this->e('Need an expert plugin developer?') ?>
	 <a href="http://hackadelic.com/contact"><?php $this->e('Contact me') ?>!</a></em>
	</p> */ ?>
</div>
