<?php

load_theme_textdomain('iodiir');
include('includes/semantics.php');

// Check for an updated version of the theme
function iodiir_version() {
	$installedVersion = "0.6.0";
	
	echo "<script src=\"http://wp-iodiir.sf.net/wp-content/themes/iodiir/includes/iodiir-version.php?version=$installedVersion\" type=\"text/javascript\"></script>";
}
// Template tag: echoes a page list for navigation 
// Sandbox based, plus options
function iodiir_globalnav() {
	global $pages_to_exclude;
	$iodiir_is_front = get_option('page_on_front'); 
	$iodiir_frontpage = get_option('show_on_front');
	if(get_settings('iodiir_excludepages')!='')
	{ 
		$pages_to_exclude = get_settings('iodiir_excludepages');
	}	
	echo "<div id='globalnav'><ul id='menu'>";
	if ( $iodiir_frontpage == 'page' ) {
	$menu = wp_list_pages('title_li=&sort_column=menu_order&echo=0&depth=1&exclude='. $iodiir_is_front .','. $pages_to_exclude); }
	else { $menu = wp_list_pages('title_li=&sort_column=menu_order&depth=1&echo=0'); }
	echo str_replace(array("\r", "\n", "\t"), '', $menu); // Strip intratag whitespace
	echo "</ul></div>";
}

// Search form for header
function iodiir_search() { ?>
						<div id="search"><h3 class="searchform"><label for="s"><?php _e('Search', 'iodiir') ?></label></h3>
					<form id="searchform" method="get" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']) ?>">
						
							<input id="s" name="s" type="text" value="Chercher" size="10" onfocus="if (this.value == 'Chercher') {this.value = '';}" />
							<input id="searchsubmit" name="searchsubmit" type="submit" value="Chercher" />
						
					</form></div>
<?php  }


// theundersigned's theme options
$themename = "Dream in Infrared";
$shortname = "iodiir";
$options = array (
	
	array(	"name" => "About Text",
			"id" => $shortname."_about_text",
			"std" => "",
			"type" => "textarea"),
	
	array(	
			"name" => "Footer Credits",
			"id" => $shortname."_footer_credit",
			"std" => "<a href=\"#wrapper\">top</a>. [blog] is &copy; [author].  Design is [design].",
			"type" => "textarea"),
	array(
			"name" => "Post Signature",
			"id" => $shortname."_sig",
			"std" => "",
			"type" => "textarea"),
	array(
		"id" => $shortname."_body_font_family",
		"name" => "Base Font Family",
		"std" => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
		"type" => "radio",
		"options" => array(
			"'Segoe UI', 'Arial Narrow', 'Helvetica Neue', sans-serif",
			"Georgia, Times, serif",
			"'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
			"'Trebuchet MS', Helvetica, sans-serif",
			"Candara, Verdana, Geneva, sans serif"
		)	
	),
	array(	
			"name" => "Show Categories",
			"id" => $shortname."_show_cats",
			"type" => "checkbox",
			"std" => "true"
			),
	array(	
			"name" => "Show Author",
			"id" => $shortname."_show_author",
			"type" => "checkbox",
			"std" => "false"
			),
	array (
			"name" => "Show Valid XHTML",
			"id" => $shortname."_show_valid",
			"type" => "select",
			"std" => "None",
			"options" => array("XHTML-CSS", "Invalid", "None")
			),
	array (
			"name" => "Check for Updates",
			"id" => $shortname."_check_update",
			"type" => "select",
			"std" => "Dashboard",
			"options" => array("Dashboard", "Options Page", "Don't Check")
			)
);

function iodiir_add_admin() {

	global $themename, $shortname, $options;

	if ( $_GET['page'] == basename(__FILE__) ) {
	
		if ( 'save' == $_REQUEST['action'] ) {
			//special case for page exclusions
			if( isset( $_POST[ 'excludepages' ] ) ) { update_option( 'iodiir_excludepages', implode(',', $_POST['excludepages']) ); } else { delete_option( 'iodiir_excludepages' ); }
			
				//...and back to the undersigned's options
				foreach ($options as $value) {
					update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }

				foreach ($options as $value) {
					if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }

			// goto theme edit page

				header("Location: themes.php?page=functions.php&saved=true");
				die;

		} else if( 'reset' == $_REQUEST['action'] ) {
				delete_option( 'iodiir_excludepages' );
			foreach ($options as $value) {
				delete_option( $value['id'] ); }

			header("Location: themes.php?page=functions.php&reset=true");
			die;

		}
	}
if (current_user_can('edit_themes')) {
    add_theme_page($themename." Options", "Current Theme Options", 'edit_themes', basename(__FILE__), 'iodiir_admin');
}
}

function iodiir_admin() {

	global $themename, $shortname, $options;

	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
	if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
	
?>
<?php do_action('iodiir_opts') ?>
<div class="wrap">
<h2><?php echo $themename; ?> settings</h2>

<form method="post">

<table class="form-table">

<?php foreach ($options as $value) { 
	
if ($value['type'] == "text") { ?>
		
<tr valign="top"> 
	<th scope="row"><?php echo $value['name']; ?>:</th>
	<td>
		<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>" />
	</td>
</tr>

<?php } elseif ($value['type'] == "textarea") { ?>
<tr valign="top"> 
	<th scope="row"><?php echo $value['name']; ?>:</th>
	<td>
		<textarea name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" rows="5" cols="45"><?php
			 if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id'] ) ); } else { echo stripslashes($value['std'] ); } 
		?></textarea>
	</td>
</tr>

<?php } elseif ($value['type'] == "select") { ?>

	<tr valign="top"> 
		<th scope="row"><?php echo $value['name']; ?>:</th>
		<td>
			<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
				<?php foreach ($value['options'] as $option) { ?>
				<option<?php if ( get_settings( $value['id'] ) == $option) { echo ' selected="selected"'; } elseif ($option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
				<?php } ?>
			</select>
		</td>
	</tr>
<tr>
<?php 
} elseif ( $value['type'] == "radio" ) {
?>
			<tr valign="top"> 
				<th scope="row"><?php echo $value['name']; ?>:</th>
				<td>
<?php foreach ($value['options'] as $option) { ?>
					<input id="<?php echo $option; ?>" name="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php echo $option; ?>" <?php if ( get_settings( $value['id'] ) == $option) { echo 'checked="checked"'; } elseif ($option == $value['std']) { echo 'checked="checked"'; } ?> /><label class="radio-item" for="<?php echo $option; ?>"><?php echo $option; ?></label><br/>
<?php } ?>
				</td>
			</tr>
<?php
} elseif ( $value['type'] =="checkbox" ) { 
?>
      <tr valign="top">
            <th scope="row"><label class="checkbox-item" for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?>:</label></th>
            <td>
               <?php
            if(get_settings($value['id'])){
              $checked = "checked=\"checked\"";
            }else{
              $checked = "";
            }
          ?>
                <input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
                <?php  ?>
            </td>
        </tr>
<?php
}
}
	// stolen from sadish's excellent mistylook theme: http://wpthemes.info/
	global $wpdb;
	$results = $wpdb->get_results("SELECT ID, post_title from $wpdb->posts WHERE post_type='page' AND post_parent=0 ORDER BY post_title");
	$iodiir_is_front = get_option('page_on_front'); 
	$iodiir_frontpage = get_option('show_on_front');
	$excludepages = explode(',', get_settings('iodiir_excludepages'));
	
	if($results) {				
		_e('<th scope="row">Pages to exclude from global navigation:</th><td>');
		foreach($results as $page) {
			echo '<input type="checkbox" name="excludepages[]" value="' . $page->ID . '"';
			if(in_array($page->ID, $excludepages)) { echo ' checked="checked"'; }
			// since static front pages are automatically removed, 
			// we might as well make that clear on the options page.
			if ($iodiir_frontpage == 'page' && $page->ID == $iodiir_is_front){ echo ' checked="checked" disabled="disabled"'; }
			echo ' /> <a href="' . get_permalink($page->ID) . '">' . $page->post_title . '</a><br />';
		}		
	}
?>
</td></tr>
</table>

<p class="submit">
<input name="save" type="submit" value="Save changes" />	
<input type="hidden" name="action" value="save" />
</p>
</form>
<form method="post">
	<h3>Reset</h3>
<p><?php _e('If something\'s not working, and you\'ve backed up all your settings, use this button to clear the options.  This cannot be undone.'); ?>
</p>
	<div id="tablenav">
<span class="rbutton">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</span>
</div></form>
<h3>Dream in Infrared Credits</h3>
	<p>This theme is based on <a href="http://plaintxt.org/themes/sandbox">Sandbox</a> developed by <a href="http://www.plaintxt.org/">Scott Allan Wallick</a> and <a href="http://andy.wordpress.com/">Andy Skelton</a>.<br />  
	This options panel was originally developed by <a href="http://theundersigned.net">The Undersigned</a>, and has been added to by <a href="http://wpthemes.info/about/">Sadish Bala</a>, Scott Allan Wallick, <a href="http://literalbarrage.org/blog/archives/2007/05/03/a-theme-tip-for-wordpress-theme-authors/">Doug Stewart</a>, and the theme author.
	</p>
<?php
}

// add signature to posts
function iodiir_sig($content) {
	$iodiir_sig = get_option('iodiir_sig');
	if ($iodiir_sig && !is_page()) { $sig = '<p>'. $iodiir_sig .'</p>'; };
	$content .= '<div class="sig">'. stripslashes($sig) .'</div>';
	return $content;
}

// Custom Header API
// Check to see if it exists first
if (function_exists('add_custom_image_header')) {
	define('HEADER_TEXTCOLOR', 'b9b9b9');
	define('HEADER_IMAGE', '%s/img/logo.png'); // %s is theme dir uri
	define('HEADER_IMAGE_WIDTH', 125);
	define('HEADER_IMAGE_HEIGHT', 185);
	
	function header_style() {
		?>
		<style type="text/css">
		h1 a, h1 a:visited {
		background: url(<?php header_image() ?>) no-repeat 50% 0;
		}
		<?php if ( 'blank' == get_theme_mod('header_textcolor', HEADER_TEXTCOLOR) ) { ?>
			h1 a {
			text-indent: -1000em;
			}
		<?php } else { ?>
			#masthead h1#blogTitle, #masthead #blogTitle a, #blogTitle a:hover {
			color: #<?php header_textcolor() ?>;
			}
			
		<?php } ?>
		</style>
		<?php
	}
	
	function iodiir_admin_header_style() {
		?>
		<style type="text/css">
		
		#headimg {
		position: relative;
		top: 0px;
		background:#832331 url('<?php bloginfo('template_directory'); ?>/img/filigreetilered3.jpg') repeat-y fixed 69px 0 !important;
		width:175px;
		height: 225px;
		margin: 0px;
		margin-top: 0px;
		padding: 25px;
		}
		
		#headimg h1 
		{
		display: block;
		border: #b9b9b9 1px solid;
		padding: 0;
		margin: 10px 25px;
		font-family: "Segoe UI", "Arial Narrow", "Helvetica Neue", sans-serif;
		text-align: center;
		font-size: 1em;  
		letter-spacing: 1px;
		}
		#headimg h1:hover 
		{
		border: #fff 1px solid;
		background: url('<?php bloginfo('template_directory'); ?>/img/filigreetilered3.jpg') repeat-y fixed -323px 0;
		}
		
		#headimg h1 a {
		border-bottom: 0;
		padding: 0;
		margin: 0;
		padding-top: 125px;
		display: block;
		background: url(<?php header_image() ?>) no-repeat 50% 0;
		height: 60px;
		width: 100%; 
		text-decoration: none;
		color: #<?php header_textcolor() ?>;
		}
		h1 a:hover 
		{
		border-bottom: 0;
		color: #fff;
		}
		
		#desc { display: none !important; }
		
		<?php if ( 'blank' == get_header_textcolor() ) { ?>
			#headimg h1 a#name {
			text-indent: -1000em;
			display: block !important;
			color:#<?php echo HEADER_TEXTCOLOR ?>;
			}
			h1 a:hover 
			{
			border-bottom: 0;
			color: #fff !important;
			}
		<?php } ?>
		
		</style>
		<?php
	}
	// if it didn't exist, we close
}


// Modified Sandbox home link widget:
// links to blog in the blog, elsewhere links to home, states home but doesn't link at home
// not a widget.
function iodiir_homelink() {
	global $wp_db_version;
	//variables i need for linking to the blog page, not the static front page
	$iodiir_frontpage = get_option('show_on_front');
	$iodiir_page_for_posts = get_option('page_for_posts');
	$iodiir_is_front = get_option('page_on_front');
	$iodiir_blog_page = get_post($iodiir_page_for_posts, Array_A);
	$iodiir_blog_url = $iodiir_blog_page->guid;

?>
		<li class="widget widget_sandbox_homelink" id="home-link">
<?php if ( is_home() || is_page($iodiir_is_front) ) { ?>
			<h2><?php _e('HOME', 'iodiir') ?></h2>
<?php } else if ( is_single() ) {?>
			<h2><a href="<?php echo $iodiir_blog_url ?>" title="<?php _e('Back to the front page', 'iodiir') ?>" rel="home"><?php _e('BLOG', 'iodiir') ?></a></h2>
<?php } else { ?>
			<h2><a href="<?php bloginfo('home') ?>" title="<?php echo wp_specialchars(get_bloginfo('name'), 1) ?>"><?php _e('HOME', 'iodiir') ?></a></h2>
<?php } ?>
</li> 
<?php }

// CSS options
function iodiir_css() {
	$body_font = get_option('iodiir_body_font_family');
	$show_author = get_option('iodiir_show_author');
	$show_cats = get_option('iodiir_show_cats'); ?>
<style type="text/css">
body {
    font-family: <?php echo stripslashes($body_font) ?>;
}
	<?php if (!$show_author) { ?>
body.home .entry-meta .entry-author, body.archive .entry-meta .entry-author, body.search .entry-meta .entry-author, body.page .author
{ display: none; !important}
	<?php } 
	if (!$show_cats) { ?>
body.home .entry-meta .entry-category, body.archive .entry-meta .entry-category, body.search .entry-meta .entry-category, body.page .entry-category 
{ display: none; !important}
	<?php } ?>
</style>
<?php }

// Template tag & Sandbox widget: Creates a string to produce
// links in either WP 2.1 or then WP 2.0 style, relative to install
function widget_sandbox_links() {
	if ( function_exists('wp_list_bookmarks') ) {
		wp_list_bookmarks(array('title_before'=>'<h3>', 'title_after'=>'</h3>', 'show_images'=>true));
	} else {
		// Queries db for links, gets stuff to display 
		global $wpdb;

		// Results are for 2.0-style links
		$cats = $wpdb->get_results("
			SELECT DISTINCT link_category, cat_name, show_images, 
				show_description, show_rating, show_updated, sort_order, 
				sort_desc, list_limit
			FROM `$wpdb->links` 
			LEFT JOIN `$wpdb->linkcategories` ON (link_category = cat_id)
			WHERE link_visible =  'Y'
				AND list_limit <> 0
			ORDER BY cat_name ASC", ARRAY_A);
	
		if ($cats) {
			foreach ($cats as $cat) {
				$orderby = $cat['sort_order'];
				$orderby = (bool_from_yn($cat['sort_desc'])?'_':'') . $orderby;

				// Display the category name
				echo '	<li id="linkcat-' . $cat['link_category'] . '"><h3>' . $cat['cat_name'] . "</h3>\n\t<ul>\n";
				// Call get_links() with all the appropriate params
				get_links($cat['link_category'],
					'<li>',"</li>","\n",
					bool_from_yn($cat['show_images']),
					$orderby,
					bool_from_yn($cat['show_description']),
					bool_from_yn($cat['show_rating']),
					$cat['list_limit'],
					bool_from_yn($cat['show_updated']));
	
				// Close the last category
				echo "\n\t</ul>\n</li>\n";
			}
		}
	}
}


// Sandbox widgets: initializes Widgets for the Sandbox
function sandbox_widgets_init() {
	if ( !function_exists('register_sidebars') )
		return;

	// Overrides the Widgets default and uses <h3>'s for sidebar headings
	register_sidebars(10, array(
		'before_title' => "<h3 class='widgettitle'>",
		'after_title' => "</h3>\n",
	));


	// Registers the widgets specific to the Sandbox, as set earlier
	unregister_widget_control('search');
	register_sidebar_widget(__('Links', 'iodiir'), 'widget_sandbox_links', null, 'links');
	unregister_widget_control('links');

}

// Check for updates, if selected
$iodiir_updater = get_option('iodiir_check_update');
if ($iodiir_updater == "Dashboard") {	
	add_action('activity_box_end', 'iodiir_version');
} else if ($iodiir_updater == "Options Page") {
	add_action('iodiir_opts', 'iodiir_version');
}

// Custom header
add_custom_image_header('header_style', 'iodiir_admin_header_style');


// Runs our code at the end to check that everything needed has loaded
add_action('init', 'sandbox_widgets_init');
add_action('admin_menu', 'iodiir_add_admin');
add_action('the_content', 'iodiir_sig');
add_action('the_content_rss', 'iodiir_sig');

// Adds filters for greater compliance
add_filter('archive_meta', 'wptexturize');
add_filter('archive_meta', 'convert_smilies');
add_filter('archive_meta', 'convert_chars');
add_filter('archive_meta', 'wpautop');

?>
