<?php
if ( !defined('ABSPATH') )
	exit('Sorry, you are not allowed to access this page directly.');
if ( !isset($this) || !is_a($this, HackadelicSeriesAdmin)   )
	exit('Invalid operation context.');

$this->handleRequest($msg);
$allseries = $this->groupEntries();

$sSeries = $this->t('Series') . '&nbsp;&nbsp;&nbsp;&nbsp;';
$sRename = $this->t('Rename');
$sEntries = $this->t('Entries');
$sEdit = $this->t('Edit');
$sView = $this->t('View');

$metakeyEditClickCode = "jQuery('.meta_key_editor').toggle()";
?>
<style>
	ol.hackadelic-series-list { margin: .5em 170px .5em 3em; list-style-type: decimal }
	ol.hackadelic-series-list li { margin: 0; padding: .25em 0 }
	ol.hackadelic-series-list li .ui { display:none }
	ol.hackadelic-series-list li:hover .ui { display:inline }
	ol.hackadelic-series-list li:hover { background-color: whitesmoke }
	div.meta_key_editor input[readonly] { background-color: #efefef }
	#meta_key_form {
		margin-bottom: .5em; padding: 5px; max-width: 50em
		border: 1px solid #ccc;
		border: 1px solid firebrick;
		background-color: navajowhite;
	}
	.help-text { font-size: 8pt; font-style: italic }
</style>

<?php
$slugHome = $slugWP = 'series';
$admPageTitle = $this->t('Administration');
include 'hackadelic-StdAdmPageIntro.php';
?>
<?php if (isset($msg)) : ?>
<div id="message" class="updated fade">
<p><?php echo $msg ?></p>
</div>
<?php endif ?>

<div class="meta_key_editor">

<label for="meta_key_view"><?php $this->e('Meta key') ?><!--[if IE]>&nbsp;<![endif]--></label>
<input readonly="1" type="text" size="50" id="meta_key_view" value="<?php echo $this->META_KEY ?>" />
<?php $this->admin_button($this->t('Edit it') . ' &raquo', $metakeyEditClickCode)
?>
</div>
<form method="post" class="meta_key_editor hidden" id="meta_key_form">
	<div class="help-text">
	<?php $this->e("The meta-key is the custom field key used to associate posts with series.
	You'd want to change this if you neeed to use another custom field with series semantics
	(for example, as imposed by the 'Serial Posts' plugin)") ?>.<br /><br />
	<strong><?php $this->e("Care must be taken when renaming to an existing meta-key.
	Posts with a custom field of that name already attached will be considered members of series from then on.") ?></strong>
	<br /><br />
	</div>
	<input type="hidden" name="page" value="<?php echo $_REQUEST['page']; ?>" />
	<input type="hidden" name="action" value="migrate-meta" />
	<label for="meta_key"><?php $this->e('Meta-key') ?></label>
	<input type="hidden" name="from" value="<?php echo $this->META_KEY; ?>" />
	<input type="text" size="50" name="to" id="meta_key" value="<?php echo $this->META_KEY ?>" />
	<?php $this->admin_button($sRename, '', 'submit', 
		$this->t('This will both, rename the meta key, and update the option')) ?>
	<?php $this->admin_button($this->t('Cancel'), $metakeyEditClickCode) ?>
</form>

<?php if (!$allseries) : ?>
<p><?php $this->e('There are currently no series') ?></p>
<?php else : ?>

<div class="hackadelic-admin-pane">
<?php $nr = 0; foreach ($allseries as $title => $series) : ++$nr; $tid = "to-$nr"; ?>
<form class="hackadelic-series-form" method="post">
	<input type="hidden" name="page" value="<?php echo $_REQUEST['page']; ?>" />
	<input type="hidden" name="action" value="rename" />
	<label for="<?php echo $tid ?>"><?php echo $sSeries ?></label>
	<input type="hidden" name="from" value="<?php echo $title ?>" readonly />
	<input type="text" size="50" name="to" id="<?php echo $tid ?>" value="<?php echo $title ?>" />

	<?php $this->admin_button($sRename, '', 'submit') ?>
	<?php $this->admin_button($sEntries.' &raquo;', "jQuery('#members-$nr').slideToggle('fast')") ?>
</form>
<ol class="hidden hackadelic-series-list" id="members-<?php echo $nr ?>">
<?php foreach ($series->members as $p) : ?>
	<li>
		<?php echo ($p->status != 'publish') ? "<em>$p->title</em>" : $p->title ?>
		<span class="ui">
		(<a href="<?php $this->editurl($p) ?>"><?php echo $sEdit ?></a>
		| <a href="<?php $this->viewurl($p) ?>"><?php echo $sView ?></a>)
		</span>
	</li>
<?php endforeach // foreach $series->members ?>
</ol>
<?php endforeach // foreach $allseries ?>
</div>
<?php endif // if allseries ?>

</div>
<?php if (isset($msg)) : ?>
<script>
jQuery(function(){
	jQuery('.fade').fadeOut(10000);
});
</script>
<?php endif ?>