<?php
if ( !defined('ABSPATH') )
	exit("Sorry, you are not allowed to access this page directly.");
if ( !isset($this) || !is_a($this, HackadelicSeriesFrontend) )
	exit("Invalid operation context.");

$options = array(
	array(
		'optitle' => 'Series Title(s) Heading', 
		'opkey' => $this->fullname('MAIN_INTRO'),
		'opval' => $this->MAIN_INTRO,
		'ophlp' => 'The heading that appears before the series title(s)' ),
	array(
		'optitle' => 'Post List Heading', 
		'opkey' => $this->fullname('LIST_INTRO'),
		'opval' => $this->LIST_INTRO,
		'ophlp' => 'The heading that appears before the list of posts in a series' ),
);

$slugHome = $slugWP = 'series';
$admPageTitle = $this->t('Settings');
include 'hackadelic-StdAdmPageIntro.php';
?>

<form method="post" action="options.php">
<?php wp_nonce_field('update-options'); ?>

<table class="form-table" style="clear:none">

<?php foreach ($options as $each) :	extract($each) ; $oplist[] = $opkey ?>
<tr>
<td>
	<input type="text" name="<?php echo $opkey ?>" value="<?php echo $opval ?>" style="width:100%" />
	<div><em><?php $this->e($ophlp) ?></em></div>
</td>
<th scope="row"><?php $this->e($optitle) ?></th>
</tr>
<?php endforeach ?>

</table>

<input type="hidden" name="action" value="update" />
<input type="hidden" name="page_options" value="<?php echo join(',', $oplist) ?>" />
<p class="submit">
<input type="submit" name="Submit" value="<?php _e('Save Changes') ?>" />
</p>
</form>

</div>
