<?php

    include("../starscape_static.php");
    include("../../styles/styles.php");
    
    header('Content-Type: application/javascript');

?>

function loadNovaPreset() {
    var novaPresets = [<?php echo hScape::rendernovapresets($starscape_nova); ?>];
    var engine_input = document.getElementById("ss_novapreset");
    var index = engine_input.options[engine_input.selectedIndex].value;
    var p = novaPresets[index];
    
    document.getElementById("ss_novatypo").value = p.typography;
    document.getElementById("ss_novacolorfooter").value = p.footer_color;
    document.getElementById("ss_novabgfooter").value = p.footer_image;
    document.getElementById("ss_novafbarcolor").value = p.footerbar_color;
    document.getElementById("ss_novafbarimage").value = p.footerbar_image;
    document.getElementById("ss_novaheadercolor").value = p.header_color;
    document.getElementById("ss_novabgheader").value = p.header_image;
    document.getElementById("ss_novacentercolor").value = p.center_color;
    document.getElementById("ss_novabgcenter").value = p.center_image;
}

function starscapeSetStatus(status) {
    var action = document.getElementById("ss_action");
    action.value = status;
}

function starscapeEngine() {
    var engine_input = document.getElementById("ss_engine");
    var index = engine_input.options[engine_input.selectedIndex].value;
    
    if (index == '0') {
        document.getElementById("engineClassic").style.display = "block";
        document.getElementById("engineNova").style.display = "none";
    }
    if (index == '1') {
        document.getElementById("engineClassic").style.display = "none";
        document.getElementById("engineNova").style.display = "block";
    }
}

function starscapeStyle(baseurl) {
    var starscapeAllImages = [ <?php echo hScape::renderjsstyles($starscape_styles); ?> ];

    var input_white = document.getElementById("ss_stylewhite");
    var input_shadow = document.getElementById("ss_styleshadow");
    var selection = document.getElementById("ss_style");
    var starscapeImage = document.getElementById("ss_styleimage");
    
    var index = selection.options[selection.selectedIndex].value;
    var white = '';
    var shadow = '';
    if (input_white.checked) white = '_white';
    if (input_shadow.checked) shadow = '_shadow';
    starscapeImage.src = baseurl + "/styles/previews/" + starscapeAllImages[index] + shadow + white + '.png';
}

function starscapeButton(baseurl) {
    var starscapeAllButtons = [ <?php echo hScape::renderjsbuttons($starscape_datebuttons); ?> ];

    var input = document.getElementById("ss_datebuttonround");
    var selection = document.getElementById("ss_buttonstyle");
    var starscapeButton = document.getElementById("ss_stylebuttonimage");

    var index = selection.options[selection.selectedIndex].value;
    var round = '';
    if (input.checked) round = '_round';
    starscapeButton.src = baseurl + "/styles/buttons/" + starscapeAllButtons[index] + "/date_button" + round +".png";
}

function starscapeHeaderRender(index) {
    if (index == "txt") {
        document.getElementById("ssfstxt").style.display = "block";
        document.getElementById("ssfsimg").style.display = "none";
        document.getElementById("ssfsoff").style.display = "none";
    }
    if (index == "img") {
        document.getElementById("ssfstxt").style.display = "none";
        document.getElementById("ssfsimg").style.display = "block";
        document.getElementById("ssfsoff").style.display = "none";
    }
    if (index == "off") {
        document.getElementById("ssfstxt").style.display = "none";
        document.getElementById("ssfsimg").style.display = "none";
        document.getElementById("ssfsoff").style.display = "block";
    }
}

function addOption(theSel, theText, theValue) {
    var newOpt = new Option(theText, theValue);
    var selLength = theSel.length;
    theSel.options[selLength] = newOpt;
}

function deleteOption(theSel, theIndex) { 
    var selLength = theSel.length;
    if(selLength>0) {
        theSel.options[theIndex] = null;
    }
}

function orderOptionsUp() {
    var list = document.getElementById("ss_topmenuselected");
    var index = list.options[list.selectedIndex].value;
    if (index > 0) {
        var value = list.options[index].value;
    }
}

function orderOptionsDown() {
    var list = document.getElementById("ss_topmenuselected");
    var index = list.selectedIndex;
    if (index > 0) {
        var value = list.options[index].value;
    }
}

function moveOptions(theSelFrom, theSelTo) {
    var selLength = theSelFrom.length;
    var selectedText = new Array();
    var selectedValues = new Array();
    var selectedCount = 0;

    var i;
      
    for(i = selLength-1; i >= 0; i--) {
        if(theSelFrom.options[i].selected) {
            selectedText[selectedCount] = theSelFrom.options[i].text;
            selectedValues[selectedCount] = theSelFrom.options[i].value;
            deleteOption(theSelFrom, i);
            selectedCount++;
        }
    }
      
    for(i = selectedCount - 1; i >= 0; i--) {
        addOption(theSelTo, selectedText[i], selectedValues[i]);
    }

    makeHidden();
}

function makeHidden() {
    theSelForm = document.getElementById('ss_topmenuselected');
    theHidField = document.getElementById('ss_topmenuitems');
    
    var selLength = theSelForm.length;
    var selectedItems = '';
    
    for (i = 0; i < selLength; i++) {
        selectedItems = selectedItems + theSelForm.options[i].value;
    }
    theHidField.value = selectedItems;
}