<?php

class bScape {
    function rendertopmenu($selecteditems, $forumurl, $icons, $iconset) {
        global $userdata;
        $iconurl = get_bloginfo('template_url')."/styles/icons/".$iconset."/icon_";
        if (is_object($userdata)) {
            $logged = true;
            if ($userdata->user_level > 1)
                $new_post = true;
            else
                $new_post = false;
        }
        else {
            $logged = false;
            $new_post = false;
        }

        $all_items = hScape::getallmenuitems();
        $sel_items = hScape::getmenuitems($selecteditems);
        $response = "";
        for ($i=0;$i<count($sel_items);$i++) {
            for ($j=0;$j<count($all_items);$j++) {
                if ($all_items[$j]["code"] == $sel_items[$i]) {
                    $item = $all_items[$j];
                    break;
                }
            }
            $render = true;
            $url = get_bloginfo('home');
            if ($sel_items[$i] == "F") $url = $forumurl;
            if ($sel_items[$i] == "S") $url = get_bloginfo('rss2_url');
            if ($sel_items[$i] == "A") {
                if (!$logged) $render = false;
                $url.= '/wp-admin';
            }
            if ($sel_items[$i] == "R") {
                if ($logged) $render = false;
                $url.= '/wp-register.php';
            }
            if ($sel_items[$i] == "L") {
                if ($logged) $render = false;
                $url.= '/wp-login.php';
            }
            if ($sel_items[$i] == "N" && $new_post) {
                $url.= '/wp-admin/post-new.php';
            }
            if ($sel_items[$i] == "N" && $new_post == false) {
                $render = false;
            }
            
            if ($render) {
                if ($icons == 1) {
                    $response.= '<td height="16" width="18" align="left"><a href="'.$url.'"><img class="png noborder" alt="icon" src="'.$iconurl.$item["icon"].'.png" /></a></td>';
                }
                $response.= '<td height="16" class="tdcell"><a href="'.$url.'">'.$item["name"].'</a></td>';
            }
        }
        return $response;
    }
    
    function getgravatar($email, $size = 52) {
        $gravatar = array(
            'default' => get_bloginfo('template_url').'/images/gravatar.jpg',
            'size' => $size,
            'rating' => 'g'
        );
        
        if (function_exists(get_avatar)) {
            return get_avatar($email, $gravatar["size"], $gravatar["default"]);
        }
        else {
            $email = trim($email);
            if ($email != '') {
                $url = 'http://www.gravatar.com/avatar/';
                $url.= md5($email).'.jpg';
                $url.= '?r='.$gravatar["rating"];
                $url.= '&s='.$gravatar["size"];
                $url.= '&d='.urlencode($gravatar["default"]);
            }
            else $url = $gravatar["default"];
            return '<img class="postcommentgravatar" src="'.$url.'" />';
        }
    }

    function getwebsiteahref($url) {
        $url = trim($url);
        if ($url == '' || $url == 'http://') return '';
        return '<li>Web: <a href="'.$url.'">'.$url.'</a></li>';
    }
    
	function getuserrole($role) {
		if ($role == 0) return 'Subscriber';
		if ($role == 1) return 'Contributor';
		if ($role == 2) return 'Author';
		if ($role > 7) return 'Administrator';
		return 'Editor';
	}
	
    function loadheaderprint($theme) {
        do_action('get_header');
        if (file_exists(TEMPLATEPATH.'/themes/'.$theme.'/print.header.php'))
            load_template(TEMPLATEPATH.'/themes/'.$theme.'/print.header.php');
        else
            load_template(TEMPLATEPATH.'/header.php');
    }
    
    function loadfooterprint($theme) {
        do_action('get_footer');
        if (file_exists(TEMPLATEPATH.'/themes/'.$theme.'/print.footer.php'))
            load_template(TEMPLATEPATH.'/themes/'.$theme.'/print.footer.php');
        else
            load_template(TEMPLATEPATH.'/footer.php');
    }

    function loadsidebarright() {
        do_action('get_sidebar');
        if (file_exists(TEMPLATEPATH.'/modules/sidebar_right.php'))
            load_template(TEMPLATEPATH.'/modules/sidebar_right.php');
    }

    function loadsidebarleft() {
        do_action('get_sidebar');
        if (file_exists(TEMPLATEPATH.'/modules/sidebar_left.php'))
            load_template(TEMPLATEPATH.'/modules/sidebar_left.php');
    }

    function loadsidebarfooter() {
        do_action('get_sidebar');
        if (file_exists(TEMPLATEPATH.'/modules/sidebar_footer.php'))
            load_template(TEMPLATEPATH.'/modules/sidebar_footer.php');
    }
    
    function comment_date($comment, $d = '') {
        if ( '' == $d )
            $date = mysql2date( get_option('date_format'), $comment->comment_date);
        else
            $date = mysql2date($d, $comment->comment_date);
        return apply_filters('get_comment_date', $date, $d);
    }

    function comment_time($comment, $d = '', $gmt = false) {
        $comment_date = $gmt? $comment->comment_date_gmt : $comment->comment_date;
        if ( '' == $d )
            $date = mysql2date(get_option('time_format'), $comment_date);
        else
            $date = mysql2date($d, $comment_date);
        return apply_filters('get_comment_time', $date, $d, $gmt);
    }

    function comment_author_link($comment) {
        $url = apply_filters('get_comment_author_url', $comment->comment_author_url);
        if (empty($comment->comment_author))
            $author = __("Anonymous", "starscape-theme");
        else
            $author = $comment->comment_author;
        $author = apply_filters('get_comment_author', $author);

        if (empty( $url ) || 'http://' == $url)
            $return = $author;
        else
            $return = "<a href='$url' rel='external nofollow'>$author</a>";
        return apply_filters('get_comment_author_link', $return);
    }

    function draw_pager($total_pages, $current_page) {
        $pages = array();
        $break_first = -1;
        $break_last = -1;
        if ($total_pages < 15) for ($i = 0; $i < $total_pages; $i++) $pages[] = $i + 1;
        else {
            
            $island_start = $current_page - 1;
            $island_end = $current_page + 1;
            
            if ($current_page == 1) $island_end = 4;
            if ($current_page == $total_pages) $island_start = $island_start - 1;
            
            if ($island_start > 5) {
                for ($i = 0; $i < 4; $i++) $pages[] = $i + 1;
                $break_first = 4;
            }
            else {
                for ($i = 0; $i < $island_end; $i++) $pages[] = $i + 1;
            }
            
            if ($island_end < $total_pages - 5) {
                for ($i = 0; $i < 4; $i++) $pages[] = $i + $total_pages - 3;
                $break_last = $total_pages - 3;
            }
            else {
                for ($i = 0; $i < $total_pages - $island_start + 1; $i++) $pages[] = $island_start + $i;
            }
            
            if ($island_start > 5 && $island_end < $total_pages - 5) {
                for ($i = 0; $i < 4; $i++) $pages[] = $island_start + $i;
            }
        }
        $previous_page = $current_page == 1 ? 1 : $current_page - 1;
        $next_page = $current_page == $max_page ? $max_page : $current_page + 1;

        
        sort($pages, SORT_NUMERIC);
        $render = '';
        $render.= '<div class="pagenavg"><span class="pagenav-pager">[ Page <strong>'.$current_page.'</strong> of <strong>'.$total_pages.'</strong> ]</span>';
        $render.= '<a href="'.get_pagenum_link(1).'"><span class="pagenav-start">&lt;&lt;</span></a>';
        $render.= '<a href="'.get_pagenum_link($previous_page).'"><span class="pagenav-prev">&lt;</span></a>';
        foreach ($pages as $page) {
            if ($page == $break_last)
                $render.= "... ";
            if ($page == $current_page) 
                $render.= sprintf('<span class="pagenav-current">%s</span>', $page);
            else
                $render.= sprintf('<a class="pagenavg-numbers" href="%s"><span class="pagenav-current">%s</span></a>', get_pagenum_link($page), $page);
            if ($page == $break_first)
                $render.= "... ";
        }

        $render.= '<a href="'.get_pagenum_link($next_page).'"><span class="pagenav-next">&gt;</span></a>';
        $render.= '<a href="'.get_pagenum_link($max_page).'"><span class="pagenav-last">&gt;&gt;</span></a>';
        $render.= '</div>';
                
        return $render;
    }

    function draw_pager_star($total_pages, $current_page) {
        $pages = array();
        $break_first = -1;
        $break_last = -1;
        if ($total_pages < 10) for ($i = 0; $i < $total_pages; $i++) $pages[] = $i + 1;
        else {
            
            $island_start = $current_page - 1;
            $island_end = $current_page + 1;
            
            if ($current_page == 1) $island_end = 3;
            if ($current_page == $total_pages) $island_start = $island_start - 1;
            
            if ($island_start > 4) {
                for ($i = 0; $i < 3; $i++) $pages[] = $i + 1;
                $break_first = 3;
            }
            else {
                for ($i = 0; $i < $island_end; $i++) $pages[] = $i + 1;
            }
            
            if ($island_end < $total_pages - 4) {
                for ($i = 0; $i < 3; $i++) $pages[] = $i + $total_pages - 2;
                $break_last = $total_pages - 2;
            }
            else {
                for ($i = 0; $i < $total_pages - $island_start + 1; $i++) $pages[] = $island_start + $i;
            }
            
            if ($island_start > 4 && $island_end < $total_pages - 4) {
                for ($i = 0; $i < 3; $i++) $pages[] = $island_start + $i;
            }
        }
        sort($pages, SORT_NUMERIC);
        $render = '';
        foreach ($pages as $page) {
            if ($page == $break_last)
                $render.= "... ";
            if ($page == $current_page) 
                $render.= sprintf('<span class="page-numbers sscurrent">%s</span>', $page);
            else
                $render.= sprintf('<a class="page-numbers" href="%s">%s</a>',  get_pagenum_link($page), $page);
            if ($page == $break_first)
                $render.= "... ";
        }
        
        if ($current_page > 1) $render.= sprintf('<a class="ssprevious page-numbers" href="%s">Previous</a>', get_pagenum_link($current_page - 1));
        if ($current_page < $total_pages) $render.= sprintf('<a class="ssnext page-numbers" href="%s">Next</a>', get_pagenum_link($current_page + 1));
        
        return $render;
    }
}

?>