<?php get_header() ?>

	<div id="container">
		<div id="content" class="hfeed">



			<div id="nav-above" class="navigation">
				<div class="nav-previous"><?php next_posts_link(__('Older posts', 'iodiir')) ?></div>
				<div class="nav-next"><?php previous_posts_link(__('Newer posts', 'iodiir')) ?></div>
			<?php the_post() ?>

			<?php if ( is_day() ) : ?>
			<h2 class="page-title"><?php printf(__('Daily Archives: <span>%s</span>', 'iodiir'), get_the_time('F jS, Y')) ?></h2>
			<?php elseif ( is_month() ) : ?>
			<h2 class="page-title"><?php printf(__('Monthly Archives: <span>%s</span>', 'iodiir'), get_the_time('F Y')) ?></h2>
			<?php elseif ( is_year() ) : ?>
			<h2 class="page-title"><?php printf(__('Yearly Archives: <span>%s</span>', 'iodiir'), get_the_time('Y')) ?></h2>
			<?php elseif ( is_author() ) : ?>
			<h2 class="page-title"><?php $curauth = sandbox_get_author(); printf(__('Author Archives: <span>%s</span>', 'iodiir'),  $curauth->display_name) ?></h2>
			<?php elseif ( isset($_GET['paged']) && !empty($_GET['paged']) ) : ?>
			<h2 class="page-title"><?php _e('Blog Archives', 'iodiir') ?></h2>
			<?php endif; ?>

			<?php rewind_posts() ?>
			</div>

<?php while ( have_posts() ) : the_post(); ?>

			<div id="post-<?php the_ID() ?>" class="<?php sandbox_post_class() ?>">
				<h3 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php printf(__('Permalink to %s', 'iodiir'), wp_specialchars(get_the_title(), 1)) ?>" rel="bookmark"><?php the_title() ?></a></h3>
				<div class="entry-date"><abbr class="published" title="<?php the_time('Y-m-d\TH:i:sO'); ?>"><?php unset($previousday); printf(__('%1$s &#8211; %2$s', 'iodiir'), the_date('', '', '', false), get_the_time()) ?></abbr></div>
				<div class="entry-meta">
					<span class="entry-author author vcard"><?php printf(__('By %s', 'iodiir'), '<a class="url fn n" href="'.get_author_link(false, $authordata->ID, $authordata->user_nicename).'" title="View all posts by ' . $authordata->display_name . '">'.get_the_author().'</a>') ?></span>
					<span class="meta-sep">|</span>
					<span class="entry-category"><?php if (function_exists(UTW_ShowTagsForCurrentPost)) {  UTW_ShowTagsForCurrentPost("commalist"); } else { ?><?php printf(__('Posted in %s', 'iodiir'), get_the_category_list(', ')); } ?></span>
					<span class="meta-sep">|</span>
<?php edit_post_link(__('Edit', 'iodiir'), "\t\t\t\t\t<span class='entry-edit'>", "</span>\n\t\t\t\t\t<span class='meta-sep'>|</span>\n"); ?>
					<span class="entry-commentlink"><?php comments_popup_link(__('Comments (0)', 'iodiir'), __('Comments (1)', 'iodiir'), __('Comments (%)', 'iodiir')) ?></span>
					<?php the_tags(__('<span class="entry-tags">Tagged ', 'sandbox'), ", ", "</span>\n\t\t\t\t\t<span class=\"meta-sep\">|</span>\n") ?>
				</div>
				<div class="entry-content entry-summary">
<?php if (function_exists('the_excerpt_reloaded')) { the_excerpt_reloaded (50, '<a><em><strong><abbr><acronym>', 'content', true, '<span class="more-link">'.__('Keep Reading &rarr;', 'iodiir').'</span>', true, 1, true); } else { the_excerpt('<span class="more-link">'.__('Keep Reading &rarr;', 'iodiir').'</span>'); } ?>

				</div>

			</div><!-- .post -->

<?php endwhile ?>

			<div id="nav-below" class="navigation">
				<div class="nav-previous"><?php next_posts_link(__('&laquo; Older posts', 'iodiir')) ?></div>
				<div class="nav-next"><?php previous_posts_link(__('Newer posts &raquo;', 'iodiir')) ?></div>
			</div>

		</div><!-- #content .hfeed -->
	</div><!-- #container -->

<?php get_sidebar() ?>
<?php get_footer() ?>