<?php get_header() ?>
	
	<div id="container">
		<div id="content" class="hfeed">
			<div id="nav-above" class="navigation">
				<div class="nav-previous"><?php next_posts_link(__('Older posts', 'iodiir')) ?></div>
				<div class="nav-next"><?php previous_posts_link(__('Newer posts', 'iodiir')) ?></div>
					<h2 class="page-title"><?php _e('Category Archives:', 'iodiir') ?> <span><?php echo single_cat_title(); ?></span></h2>
					<div class="archive-meta"><?php echo apply_filters('archive_meta', category_description()); ?>
					<span class="subscribe"><?php _e('Category Feed:', 'iodiir') ?><a href="<?php the_category_rss() ?>" title="<?php _e('Subscribe to Posts in this Category', 'iodiir') ?>" rel="alternate" type="application/rss+xml" class="rsswidget"><img src="<?php bloginfo('siteurl') ?>/wp-includes/images/rss.png" alt="RSS" title="RSS Icon" /></a></span></div>

			</div>

<?php while (have_posts()) : the_post(); ?>

			<div id="post-<?php the_ID(); ?>" class="<?php sandbox_post_class(); ?>">
				<h3 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php printf(__('Permalink to %s', 'iodiir'), get_the_title()) ?>" rel="bookmark"><?php the_title() ?></a></h3>
				<div class="entry-date"><abbr class="published" title="<?php the_time('Y-m-d\TH:i:sO'); ?>"><?php unset($previousday); printf(__('%1$s &#8211; %2$s', 'iodiir'), the_date('', '', '', false), get_the_time()) ?></abbr></div>
				<div class="entry-meta">
					<span class="entry-author author vcard"><?php printf(__('By %s', 'iodiir'), '<a class="url fn n" href="'.get_author_link(false, $authordata->ID, $authordata->user_nicename).'" title="View all posts by ' . $authordata->display_name . '">'.get_the_author().'</a>') ?></span>
					<span class="meta-sep">|</span>
<?php if ( $cats_meow = sandbox_cats_meow(', ') ) : /* only show categories other than the one queried */ ?>
					<span class="entry-category"><?php printf(__('Also posted in %s', 'iodiir'), $cats_meow) ?></span>
					<span class="meta-sep">|</span>
<?php endif ?>
<?php edit_post_link(__('Edit', 'iodiir'), "\t\t\t\t\t<span class='entry-edit'>", "</span>\n\t\t\t\t\t<span class='meta-sep'>|</span>\n"); ?>
					<span class="entry-commentlink"><?php comments_popup_link(__('Comments (0)', 'iodiir'), __('Comments (1)', 'iodiir'), __('Comments (%)', 'iodiir')) ?></span>
					<?php the_tags(__('<span class="entry-tags">Tagged ', 'sandbox'), ", ", "</span>\n\t\t\t\t\t<span class=\"meta-sep\">|</span>\n") ?>
				</div>
				<div class="entry-content entry-summary">
<?php if (function_exists('the_excerpt_reloaded')) { the_excerpt_reloaded (50, '<a><em><strong><abbr><acronym>', 'content', true, '<span class="more-link">'.__('Keep Reading &rarr;', 'iodiir').'</span>', true, 1, true); } else { the_excerpt('<span class="more-link">'.__('Keep Reading &rarr;', 'iodiir').'</span>'); } ?>

				</div>

			</div><!-- .post -->

<?php endwhile; ?>

			<div id="nav-below" class="navigation">
				<div class="nav-previous"><?php next_posts_link(__('&laquo; Older posts', 'iodiir')) ?></div>
				<div class="nav-next"><?php previous_posts_link(__('Newer posts &raquo;', 'iodiir')) ?></div>
			</div>

		</div><!-- #content .hfeed -->
	</div><!-- #container -->

<?php get_sidebar() ?>
<?php get_footer() ?>