<?php 
/*
Template Name: Table of Contents
*/
get_header() ?>

	<div id="container">
		<div id="content" class="hfeed">

<?php the_post() ?>

			<div id="post-<?php the_ID(); ?>" class="<?php sandbox_post_class() ?>">
				<h2 class="entry-title"><?php the_title(); ?></h2>
				<div class="entry-content">
<span class="author-inpost">
Par <?php echo '<a class="url fn n" href="'.get_author_link(false, $authordata->ID, $authordata->user_nicename).'" title="' . sprintf(__('View all posts by %s', 'sandbox'), $authordata->display_name) . '">'.get_the_author().'</a>'; ?>
</span>
<?php the_content() ?>


<?php link_pages("\t\t\t\t\t<div class='page-link'>".__('Pages: ', 'iodiir'), "</div>\n", 'number'); ?>

<?php 	edit_post_link(__('Edit this entry.', 'iodiir'),'<p class="entry-edit">','</p>'); ?>

				</div>
			</div><!-- .post -->
		</div><!-- #content .hfeed -->
	</div><!-- #container -->

<div id="primary" class="sidebar">
<ul>
	<?php iodiir_homelink() ?>
</ul>
<?php if (!function_exists('dynamic_sidebar') || !dynamic_sidebar(7) ) : // begin primary sidebar widgets ?>
				<li class="widget">
					
				</li>
<?php endif; // end primary sidebar widgets   ?>


</div><!-- #primary .sidebar -->
		<?php 	$cat_contents = get_post_meta($post->ID, cat_contents, TRUE);
				$kids = get_pages('child_of='. $post->ID);
				if ($cat_contents) { ?>
					<div id="sub_pages"><h3 class="content_heading"><?php _e('Contents', 'iodiir') ?></h3><ul>
						<?php query_posts('posts_per_page=-1&cat='. $cat_contents); ?>
						<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
							<li  class="sub_page_list" id="post-<?php the_ID(); ?>">
								<strong><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>">
										<?php the_title(); ?></a></strong>
								<div class="entry-summary">
								<?php 	$thumb = get_post_meta($post->ID, 'thumbnail', TRUE);
										if ($thumb) { ?>
											<a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><img src="<?php echo $thumb ?>" alt="thumbnail" title="<?php the_title(); ?>" /></a>
										<?php } else { the_excerpt(); 
								} ?></div>
							</li><?php endwhile; endif; ?>
					</ul></div>
		<?php } elseif (count($kids) > 0) { 
			$iodiir_toc = $post->ID;
			?>
					<div id="sub_pages"><h3 class="content_heading"><?php _e('Contents', 'iodiir') ?></h3><ul>
						<?php foreach ($kids as $post): 
								$iodiir_parent = $post->post_parent;
								if ($iodiir_parent <> $iodiir_toc) {
									continue; } else {
						?>
						<?php setup_postdata($post); ?>
							<li class="sub_page_list" id="post-<?php the_ID(); ?>">
								<strong><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>">
										<?php the_title(); ?></a></strong>
								<div class="entry-summary">
								<?php 	$thumb = get_post_meta($post->ID, 'thumbnail', TRUE);
										if ($thumb) { ?>
											<a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><img src="<?php echo $thumb ?>" alt="thumbnail" title="<?php the_title(); ?>" /></a>
										<?php } else { the_excerpt(); 
								} ?></div>
							</li><?php } 
							endforeach;
							unset ($post); ?>
					</ul></div>
		<?php }
?>


<?php comments_template(); ?>
<?php get_footer() ?>