<?php

class StarscapeCommentWalker extends Walker {
    var $tree_type = 'comment';

    var $db_fields = array ('parent' => 'comment_parent', 'id' => 'comment_ID');

    function start_lvl(&$output, $depth, $args) {
        $GLOBALS['comment_depth'] = $depth + 1;

        switch ( $args['style'] ) {
            case 'div':
                break;
            case 'ol':
                echo "<ol class='children'>\n";
                break;
            default:
            case 'ul':
                echo "<ul class='children'>\n";
                break;
        }
    }

    function end_lvl(&$output, $depth, $args) {
        $GLOBALS['comment_depth'] = $depth + 1;

        switch ( $args['style'] ) {
            case 'div':
                break;
            case 'ol':
                echo "</ol>\n";
                break;
            default:
            case 'ul':
                echo "</ul>\n";
                break;
        }
    }

    function start_el(&$output, $comment, $depth, $args) {
        $depth++;
        $GLOBALS['comment_depth'] = $depth;
        $gdsr_exists = function_exists(wp_gdsr_new_comment_review);
        if ( !empty($args['callback']) ) {
            call_user_func($args['callback'], $comment, $args, $depth);
            return;
        }
        $GLOBALS['comment'] = $comment;
        extract($args, EXTR_SKIP);
        $ct = $comment->comment_type;
        $sso = get_option('starscape');
        if ( 'div' == $args['style'] ) {
            $tag = 'div';
            $add_below = 'comment';
        }
        else {
            $tag = 'li';
            $add_below = 'div-comment';
        }
?>
        <<?php echo $tag ?> <?php comment_class() ?> id="comment-<?php comment_ID() ?>">
        <?php if ( 'ul' == $args['style'] ) : ?>
        <div id="div-comment-<?php comment_ID() ?>">
        <?php endif; ?>
        
        <div class="comm_item">
            <div class="postcommentpanel">
                <div style="float: left; padding-top: 2px;"><strong><?php comment_author_link() ?></strong> on <?php comment_date('F jS, Y') ?> at <?php comment_time() ?><?php edit_comment_link('[edit]','&nbsp;',''); ?></div>
                <div style="float: right"><?php if ($ct != "pingback" && $gdsr_exists) wp_gdsr_show_comment_review(0, true, false);  ?></div>
                <div class="clearboth"></div>
            </div>
            <table><tr>
                <?php if ($sso["gravatar_comment"] == 1 && $ct != 'pingback') { ?>
                <td class="postcommenttdgravatar"><?php echo bScape::getgravatar($comment->comment_author_email); ?></td>
                <?php } ?>
                <td><div class="postcommenttext">
                <?php if ($comment->comment_approved == '0') : ?><em>Your comment is awaiting moderation.</em>
                <?php else : ss_display_comment(get_comment_ID(), get_comment_text(), $sso); endif; ?>
                </div><div class="reply"><?php comment_reply_link(array_merge( $args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?></div>
            </td></tr></table>
        
        </div>
        <?php if ( 'ul' == $args['style'] ) : ?>
        </div>
        <?php endif; ?>
<?php
    }

    function end_el(&$output, $comment, $depth, $args) {
        if ( !empty($args['end-callback']) ) {
            call_user_func($args['end-callback'], $comment, $args, $depth);
            return;
        }
        if ( 'div' == $args['style'] )
            echo "</div>\n";
        else
            echo "</li>\n";
    }
}

?>