<?php

class hScape {
    function getallmenuitems() {
        return array(
            array("code" => "H", "name" => __("Home Page", "starscape-theme"), "icon" => "home"),
            array("code" => "S", "name" => __("RSS", "starscape-theme"), "icon" => "rss"),
            array("code" => "A", "name" => __("Admin", "starscape-theme"), "icon" => "admin"),
            array("code" => "R", "name" => __("Register", "starscape-theme"), "icon" => "reg"),
            array("code" => "N", "name" => __("New Post", "starscape-theme"), "icon" => "new"),
            array("code" => "L", "name" => __("Login", "starscape-theme"), "icon" => "login"),
            array("code" => "F", "name" => __("Forum", "starscape-theme"), "icon" => "forum")
        );
    }
    
    function rendernovapresets($presets) {
        for ($i = 0; $i < count($presets); $i++) {
            echo "{";
            $keys = count($presets[$i]);
            $j = 0;
            foreach($presets[$i] as $key => $value) {
                echo sprintf("%s: '%s'", $key, $value);
                if ($j < $keys - 1)
                    echo ", ";
                $j++;
            }
            echo "}";
            if ($i < count($presets) - 1)
                echo ", ";
        }
    }
    
    function rendernovapresetslist($presets) {
        for ($i = 0; $i < count($presets); $i++) {
            $p = $presets[$i];
            echo "\t<option value='".$i."'".$current.">".$p["name"]."</option>\r\n";
        }
    }
    
    function renderrelatednumber($limit, $selected = 0) {
        for ($i = 1; $i < $limit + 1; $i++) {
            if ($selected == $i) $current = ' selected="selected"';
            else $current = '';
            echo "\t<option value='".$i."'".$current.">".$i."</option>\r\n";
        }
    }
    
    function renderselectstyles($styles, $selected = 0) {
        for ($i = 0; $i < count($styles); $i++) {
            $style = $styles[$i];
            if ($selected == $i) $current = ' selected="selected"';
            else $current = '';
            echo "\t<option value='".$i."'".$current.">".$style["name"]."</option>\r\n";
        }
    }
	
	function render404pages($pages, $selected = "classic") {
		for ($i = 0; $i < count($pages); $i++) {
			$page = $pages[$i];
			if ($selected == $page["id"]) $current = ' selected="selected"';
			else $current = '';
			echo "\t<option value='".$page["id"]."'".$current.">".$page["name"]."</option>\r\n";
		}
	}

    function rendertypography($typographies, $selected = 0) {
        for ($i = 0; $i < count($typographies); $i++) {
            $typo = $typographies[$i];
            if ($selected == $i) $current = ' selected="selected"';
            else $current = '';
            echo "\t<option value='".$i."'".$current.">".$typo["name"]."</option>\r\n";
        }
    }

    function renderengines($engines, $selected = 0) {
        for ($i = 0; $i < count($engines); $i++) {
            $engine = $engines[$i];
            if ($selected == $i) $current = ' selected="selected"';
            else $current = '';
            echo "\t<option value='".$i."'".$current.">".$engine["title"]."</option>\r\n";
        }
    }

    function rendericonsets($iconsets, $selected = 0) {
        for ($i = 0; $i < count($iconsets); $i++) {
            $iconset = $iconsets[$i];
            if ($selected == $i) $current = ' selected="selected"';
            else $current = '';
            echo "\t<option value='".$iconset["name"]."'".$current.">".$iconset["title"]."</option>\r\n";
        }
    }
        
    function renderjsstyles($styles) {
        $js = "";
        for ($i = 0; $i < count($styles); $i++) {
            $js.="'".$styles[$i]["folder"]."'";
            if ($i<count($styles)-1) $js.=",";
        }
        return $js;
    }

    function renderjsbuttons($styles) {
        $js = "";
        for ($i = 0; $i < count($styles); $i++) {
            $js.="'".$styles[$i]["color"]."'";
            if ($i<count($styles)-1) $js.=",";
        }
        return $js;
    }
    
    function scanstylesdir($path) {
        $dir  = opendir($path);
        while (false !== ($filename = readdir($dir))) {
            $files[] = $filename;
        }
        sort($files);
        return $files;
    }

    function renderlogos($selected = '_') {
        hScape::renderimagespath(TEMPLATEPATH."/styles/logos/", __("No Logo", "starscape-theme"), $selected);
    }

    function renderbackgrounds($selected = '_') {
        hScape::renderimagespath(TEMPLATEPATH."/styles/headers/", __("No Image", "starscape-theme"), $selected);
    }
    
    function rendernovabgheader($selected = '_') {
        hScape::renderimagespath(TEMPLATEPATH."/styles/nova/header/", __("No Image", "starscape-theme"), $selected);
    }

    function rendernovabgmenu($selected = '_') {
        hScape::renderimagespath(TEMPLATEPATH."/styles/nova/menu/", __("No Image", "starscape-theme"), $selected);
    }

    function rendernovabgcenter($selected = '_') {
        hScape::renderimagespath(TEMPLATEPATH."/styles/nova/center/", __("No Image", "starscape-theme"), $selected);
    }                                                                  

    function rendernovabgfooter($selected = '_') {
        hScape::renderimagespath(TEMPLATEPATH."/styles/nova/footer/", __("No Image", "starscape-theme"), $selected);
    }

    function rendernovabgfoobar($selected = '_') {
        hScape::renderimagespath(TEMPLATEPATH."/styles/nova/footerbar/", __("No Image", "starscape-theme"), $selected);
    }

    function renderfavicon($selected = '_') {
        hScape::renderimagespath(TEMPLATEPATH."/styles/favicons/", __("No Favicon", "starscape-theme"), $selected);
    }
    
    function renderimagespath($path, $none, $selected) {
        $b = hScape::scanstylesdir($path);
        if ('_' == $selected) $current = ' selected="selected"';
        else $current = '';
        echo "\t<option value='_'".$current.">".$none."</option>\r\n";
        for ($i = 0; $i < count($b); $i++) {
            if (strlen($b[$i]) > 4) {
                $ext = substr($b[$i], strlen($b[$i])-4, 4);
                if ($ext == ".ico" ||$ext == ".png" || $ext == ".gif" || $ext == ".jpg") {
                    $path_parts = pathinfo($b[$i]);
                    $filename = $path_parts['basename'];
                    if ($filename == $selected) $current = ' selected="selected"';
                    else $current = '';
                    echo "\t<option value='".$filename."'".$current.">".$filename."</option>\r\n";
                }
            }
        }
    }
    
    function getupgradedata() {
        $update_data = get_option('starscape_update');
        echo '<div class="response'.$update_data['last_available'].'">'.$update_data['last_response'].'</div>'; 
    }

    function renderchangelog() {
        if (file_exists(TEMPLATEPATH."/info/changelog.txt")) {
            $rows = file(TEMPLATEPATH."/info/changelog.txt");

            for ($i = 4;$i<count($rows);$i++) {
                $row = trim($rows[$i]);
                if (substr($row, 0, 1) == "[")
                    echo "<h5>".substr($row, 1, strlen($rows[$i])-4).".</h5><ul>";
                else if (substr($row, 0, 1) == "-") {
                    echo "<li>".substr($row, 2, strlen($rows[$i])-2)."</li>";
                }
                else
                    echo "</ul>";
            }
        }
    }
    
    function getbackgroundheight($filename) {
        $path = TEMPLATEPATH."/styles/headers/".$filename;
        $size = getimagesize($path);
        if (is_array($size))
            return $size[1];
        else
            return -1;
    }
    
    function getmenuitems($selected) {
        $el = array();
        for ($i=0;$i<strlen($selected);$i++) {
            $el[$i] = substr($selected,$i,1);
        }
        return $el;
    }

    function calculatemenuitems($selected) {
        $cal[0] = "";
        $cal[1] = "";
        
        $sel_items = hScape::getmenuitems($selected);
        $all_items = hScape::getallmenuitems();
        for ($i=0;$i<count($all_items);$i++) {
            $item = '<option value="'.$all_items[$i]["code"].'">'.$all_items[$i]["name"].'</option>';
            if (in_array($all_items[$i]["code"], $sel_items))
                $cal[1] .= $item;
            else
                $cal[0] .= $item;
        }
        
        return $cal;
    }
}

?>